<?php

namespace Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Css_Filter;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Animated_Svg_Lot extends Widget_Base {
		
	public function get_name() {
		return 'lot-svg';
	}

    public function get_title() {
        return __('Lottie Animations', 'animatesvg');
    }

    public function get_icon() {
        return 'fa fa-shapes asvglottie';
    }

    public function get_categories() {
        return array('animated-svg');
    }

	public function get_script_depends() {
		return ['animated-drwsvg'];
	}
	
	public function get_style_depends() {
		return ['asvg-editor'];
	}
	
	
	protected function _register_controls() {
		
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Basic Animations', 'asvg' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'select_svg_option',
			[
				'label' => __( 'Select option', 'animatesvg' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'lottie_icons_bas',
				'options' => [
					'lottie_icons_bas'  => __( 'Basic icons', 'animatesvg' ),
					'data_file'  => __( 'Upload Lottie', 'animatesvg' ),
					'json_url'  => __( 'Enter Lottie URL', 'animatesvg' ),
				],
			]
		);
		
		$this->add_control(
			'json_url',
			[
				'label' => esc_html__( 'Lottie URL', 'asvg' ),
				'type' => Controls_Manager::URL,				
				'placeholder' => esc_html__( 'Enter Lottie URL here', 'asvg' ),
				'default' => [
					'url' => 'https://assets6.lottiefiles.com/packages/lf20_QUHgVQ.json',
				],
				'condition' => [
					'select_svg_option' => 'json_url',					
				],
			]
		);
		
		$this->add_control(
			'data_file',
      			array(
        		'label'       => __( 'Upload your json file', 'asvg-lottie' ),
				'condition'   => array(
					'select_svg_option' => 'data_file',
				),
        		'type'        => \Elementor\Controls_Manager::MEDIA,
        		'media_type'  => 'application/json',
      )
    );	
		
		$this->add_control(
			'lottie_icons_bas',
			[
				'label' => __( 'Select Lottie icon', 'animatesvg' ),
				'type' => Controls_Manager::SELECT,
				'default' => '4.lottiefiles.com/private_files/lf30_u9c7N9.json',
				'options' => asvg_lot_lottie_list(),
				'condition' => [
					'select_svg_option' => 'lottie_icons_bas',					
				],
			]
		);

		$this->add_control(
			'customize_url',
			[
				'label' => __( 'Customize Lottie?', 'animatesvg' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'animatesvg' ),
				'label_off' => __( 'No', 'animatesvg' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
				'select_svg_option' => [ 'lottie_icons_bas', 'lottie_icons_pro' ]
				]
			]
			
          );
		
		$this->add_control(
			'customize',
			[
				'label' => __( '<span style="font-size: 12px; line-height: 1.4">Open page in preview and click on link above animation to customize image.<br><br>Watch short instructional <a href="https://www.youtube.com/watch?v=LZRdaP28Gq0&start=107" target="_blank">video</a> or check out recently added Lotties on <a href="https://lottiefiles.com/asvg" target="_blank">lottiefiles.com.</a> </span>', 'animatesvg' ),
				'type' => Controls_Manager::RAW_HTML,
				'condition' => [
				'customize_url' => 'yes',
				'select_svg_option' => [ 'lottie_icons_bas', 'lottie_icons_pro' ]
				]
			]
		);
		
		$this->add_control(
			'pro_text',
			[
				'label' => __( '<span style="font-size: 12px; line-height: 1.4">You can purchase discounted Lottie packs made by ASVG from WP admin menu <a href="/wp-admin/admin.php?page=asvg-menu-addons" target="_blank">"Add_on Icon Packs"</a>.</span>', 'animatesvg' ),
				'type' => Controls_Manager::RAW_HTML,
				'condition' => [
				'select_svg_option' => [ 'lottie_icons_pro' ]
				]
			]
		);

		$this->add_control(
			'action',
			[
				'label' => __( 'Play settings', 'asvg' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'autoplay',
				'options' => [
					'autoplay'         => __( 'Auto play', 'asvg' ),
					'hover'    => __( 'Play on hover', 'asvg' ),
					'click'    => __( 'Play on click', 'asvg' ),
					'parallax_effect'  => __( 'Play on scroll', 'asvg' ),		
					'mouseoverout'  => __( 'Reverse on mouse out', 'asvg' ),
								
				],
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'loop',
			[
				'label' => esc_html__( 'Continuous loop', 'asvg' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'OFF', 'asvg' ),
				'label_off' => esc_html__( 'ON', 'asvg' ),
				'return_value' => 'true',
				'default' => 'false',
				'condition' => [
				'action' => ['autoplay', 'hover', 'click', 'mouseoverout'],
			]
			]
		);
	
		$this->add_control(
			'loop_counter',
			[
				'label' => esc_html__( 'Number of times to play (1-999)', 'asvg' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '1',
				'min' => 1,
				'max' => 999,
				'step' => 1,
				'condition' => [
				'action' => ['autoplay', 'hover', 'click', 'mouseoverout'],
				'loop' => 'true',
				],
			]
		);
		
		$this->add_control(
			'speed',
			[
				'label' => esc_html__( 'Play speed (0.1- 5)', 'asvg' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0.1,
						'max' => 5,
                        'step' => 0.1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 1,
				],
			]
		);
		$this->add_control(
			'scrollbased',
			[
				'label' => __( 'Scroll settings', 'asvg' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'custom',
				'options' => [
					'custom' => __( 'Viewport', 'asvg' ),
					'document'  => __( 'Entire page', 'asvg' ),
				],
				'description' => __( 'In "Viewport" mode, you need to set duration and offset for animation. If you select "Entire page", animation will be based on whole page\'s height.', 'asvg' ),
				'separator' => 'before',
				'condition' => [
					'action' => 'parallax_effect',
				],
			]
		);
		
		$this->add_control(
			'section_duration',
			[
				'label' => __( 'Duration', 'asvg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 50,
						'max' => 2000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 400,
				],
				'condition' => [
					'action' => 'parallax_effect',
					'scrollbased' => 'custom',
				],
			]
		);
		$this->add_control(
			'section_offset',
			[
				'label' => __( 'Offset', 'asvg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 400,
				],
				'condition' => [
					'action' => 'parallax_effect',
					'scrollbased' => 'custom',
				],
			]
		);
		
		$this->add_control(
			'custom_time',
			[
				'label' => esc_html__( 'Custom animation timing', 'asvg' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'ON', 'asvg' ),
				'label_off' => esc_html__( 'OFF', 'asvg' ),
				'condition' => [
					'action' => ['autoplay', 'hover', 'click', 'mouseoverout', 'parallax_effect'],
					'loop' => 'true',
				],
			]
		);
		$this->add_control(
			'start_time',
			[
				'label' => esc_html__( 'Start time', 'asvg' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 100,
				'step' => 1,
				'condition' => [
					'action' => ['autoplay', 'hover', 'click', 'mouseoverout', 'parallax_effect'],
					'custom_time' => 'yes',
					'loop' => 'true',
				],
			]
		);		
		$this->add_control(
			'end_time',
			[
				'label' => esc_html__( 'End time', 'asvg' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 100,
				'step' => 1,
				'condition' => [
					'action' => ['autoplay', 'hover', 'click', 'mouseoverout', 'parallax_effect'],
					'custom_time' => 'yes',
					'loop' => 'true',
				],
			]
		);
		
		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Add link', 'asvg' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'asvg' ),
				'label_off' => esc_html__( 'no', 'asvg' ),				
				'default' => 'no',
				'separator' => 'before',
			]
		);
		
		$this->add_control(
        'column_link',
        	[
				'type'        => Controls_Manager::URL,
				'dynamic'     => [
				'active' => false,
				],
				'placeholder' => __( 'Add http:// for external URL', 'animatesvg' ),
				'selectors'   => [
				],
				'condition' => [
					'link' => 'yes',
				],
			]
      );

		$this->add_control(
			'link_delay',
			[
				'label' => esc_html__( 'Click delay (in ms)', 'asvg' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 100,
						'max' => 10000,
                        'step' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 1000,
				],
				'condition' => [
					'link' => 'yes',					
				],
				'frontend_available' => true,
			]
		);

		$this->end_controls_section();
		/*setting option end*/

		
		/*Style start*/
		$this->start_controls_section(
			'section_lotties_option',
			[
				'label' => esc_html__( 'Lottie Style', 'asvg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'content_align',
			[
				'label' => esc_html__( 'Alignment', 'jbafe' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'jbafe' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'jbafe' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'jbafe' ),
						'icon' => 'fa fa-align-right',
					],
				],				
				'default' => 'center',
				'prefix_ class' => 'text-%s',
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'max_width',
			[
				'label' => esc_html__( 'Maximum Width', 'jbafe' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'separator' => 'before',
				'render_type' => 'ui',
				'selectors' => [
					'{{WRAPPER}} .asvg-lotties-animation-wrapper' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'rotate_lottie',
			[
				'label' => __( 'Rotation', 'animatesvg' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
					'unit' => 'deg',
				],
				'selectors' => [
					'{{WRAPPER}} .asvg-lotties-animation-wrapper' => 'transform: rotate({{SIZE}}{{UNIT}});',
				],
			]
		);
		
		$this->add_responsive_control(
			'lottie_margin',
			[
				'label' => __( 'Margin (in pixels)', 'animatesvg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px'],
				'selectors' => [
					'{{WRAPPER}} .asvg-lotties-animation-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'after',
			]
		);
		
		$this->add_control(
			'space',
			[
				'label' => __( '<br>Styling options<br>', 'animatesvg' ),
				'type' => Controls_Manager::RAW_HTML,
			
			]
		);
		
		$this->start_controls_tabs( 'image_effects' );

		$this->start_controls_tab( 'normal_lottie',
			array(
				'label' => __( 'Normal', 'animatesvg' ),
				
			)
		);
		
		$this->add_control(
			'opacity_lottie',
			array(
				'label' => __( 'Opacity', 'animatesvg' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'range' => array(
					'px'  => array(
						'max'   => 1,
						'min'   => 0.10,
						'step'  => 0.01,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .asvg-lotties-animation-wrapper' => 'opacity: {{SIZE}};',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Css_Filter::get_type(),
			array(
				'name' => 'css_filters_lottie',
				'selector' => '{{WRAPPER}} .asvg-lotties-animation-wrapper',
			)
		);
		$this->add_control(
      		'shadow_add',
			[
                'label' => __( 'Shadow', 'asvg' ), 
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'asvg' ),
				'label_off' => __( 'No', 'asvg' ),
				'return_value' => 'yes',
				'default' => 'no',
				'frontend_available' => true,
				'separator' => 'before', 
			]
        );
		
		$this->add_control(
      		'shadow_x',
			 [
				'label' => __( 'Offset X', 'asvg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
                        'min' => -50,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
                        'min' => -5,
						'max' => 5,
						'step' => 0.1,
					],
                ],
                'default' => [
					'unit' => 'px',
					'size' => 2,
				],
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-widget-container' => 'filter: drop-shadow({{SIZE}}{{UNIT}} {{shadow_y.SIZE}}{{shadow_y.UNIT}} {{shadow_blur.SIZE}}{{shadow_blur.UNIT}} {{shadow_color.VALUE}});', 
                ],
                'condition' => [
					'shadow_add' => 'yes', 
				],
			]
        );
		
		$this->add_control(
			'shadow_y',
            [
				'label' => __( 'Offset Y', 'asvg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
                        'min' => -50,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
                        'min' => -5,
						'max' => 5,
						'step' => 0.1,
					],
                ],
                'default' => [
					'unit' => 'px',
					'size' => 2,
				],
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-widget-container' => 'filter: drop-shadow({{shadow_x.SIZE}}{{shadow_x.UNIT}} {{SIZE}}{{UNIT}} {{shadow_blur.SIZE}}{{shadow_blur.UNIT}} {{shadow_color.VALUE}});', 
                ],
                'condition' => [
					'shadow_add' => 'yes', 
				],
			]
        );
		
		$this->add_control(
            'shadow_blur',
            [
				'label' => __( 'Blur', 'asvg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
						'step' => 1,
					],
					'em' => [
						'max' => 10,
						'step' => 0.1,
					],
                ],
                'default' => [
					'unit' => 'px',
					'size' => 2,
				],
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-widget-container' => 'filter: drop-shadow({{shadow_x.SIZE}}{{shadow_x.UNIT}} {{shadow_y.SIZE}}{{shadow_y.UNIT}} {{SIZE}}{{UNIT}} {{shadow_color.VALUE}});', 
                ],
                'condition' => [
					'shadow_add' => 'yes', 
				],
			]
        );
		
		$this->add_control(
 			'shadow_color',
			[
				'label' => __( 'Shadow Color', 'asvg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#0000005E',
				'selectors' => [
					'{{WRAPPER}} .elementor-widget-container' => 'filter: drop-shadow({{shadow_x.SIZE}}{{shadow_x.UNIT}} {{shadow_y.SIZE}}{{shadow_y.UNIT}} {{shadow_blur.SIZE}}{{shadow_blur.UNIT}} {{VALUE}});',
                ],
                'condition' => [
					'shadow_add' => 'yes', 
				],
			]
		);
		
		$this->add_control(
      		'add_border_lottie',
      			[
        		'label'     => __( 'Border', 'animatesvg' ),
        		'type'      => Controls_Manager::SWITCHER,
				'label_on' => __( 'yes', 'your-plugin' ),
				'label_off' => __( 'no', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'no',
      			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'lottie_border',
				'selector' => '{{WRAPPER}} .asvg-lotties-animation-wrapper',
				'condition' => [
				'add_border_lottie' => 'yes',
				],
			]
		);
		
		$this->add_responsive_control(
			'border_radius_lottie',
					[
				'render_type' => 'ui',
				'type' 			=> Controls_Manager::DIMENSIONS,
				'label' 		=> __( 'Border Radius', 'animatesvg' ),
				'size_units' 	=> [ 'px' ],
				'condition' => [
				'add_border_lottie' => 'yes',
				],
				'selectors' => [
					'{{WRAPPER}} .asvg-lotties-animation-wrapper'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				]
				);
		
		$this->end_controls_tab();

		$this->start_controls_tab( 'hover_lottie',
			array(
				'label' => __( 'Hover', 'animatesvg' ),
			)
		);

		$this->add_control(
			'opacity_lottie_hover',
			array(
				'label' => __( 'Opacity', 'animatesvg' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'range' => array(
					'px'  => array(
						'max'   => 1,
						'min'   => 0.10,
						'step'  => 0.01,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .asvg-lotties-animation-wrapper:hover' => 'opacity: {{SIZE}};',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Css_Filter::get_type(),
			array(
				'name' => 'css_filters_lottie_hover',
				'selector' => '{{WRAPPER}} .asvg-lotties-animation-wrapper:hover',
			)
		);

		$this->add_control(
			'hover_transition_lottie',
			array(
				'label' => __( 'Transition Duration', 'animatesvg' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'range' => array(
					'px'  => array(
						'max'   => 3,
						'step'  => 0.1,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .asvg-lotties-animation-wrapper' => 'transition-duration: {{SIZE}}s',
				),
			)
		);
		
		$this->add_control(
      		'shadow_add_hover',
			[
                'label' => __( 'Shadow', 'asvg' ), 
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'asvg' ),
				'label_off' => __( 'No', 'asvg' ),
				'return_value' => 'yes',
				'default' => 'no',
				'frontend_available' => true,
				'separator' => 'before', 
			]
        );
		
		$this->add_control(
      		'shadow_x_hover',
			 [
				'label' => __( 'Offset X', 'asvg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
                        'min' => -50,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
                        'min' => -5,
						'max' => 5,
						'step' => 0.1,
					],
                ],
                'default' => [
					'unit' => 'px',
					'size' => 2,
				],
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-widget-container:hover' => 'filter: drop-shadow({{SIZE}}{{UNIT}} {{shadow_y_hover.SIZE}}{{shadow_y_hover.UNIT}} {{shadow_blur_hover.SIZE}}{{shadow_blur_hover.UNIT}} {{shadow_color_hover.VALUE}});', 
                ],
                'condition' => [
					'shadow_add_hover' => 'yes', 
				],
			]
        );
		
		$this->add_control(
			'shadow_y_hover',
            [
				'label' => __( 'Offset Y', 'asvg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
                        'min' => -50,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
                        'min' => -5,
						'max' => 5,
						'step' => 0.1,
					],
                ],
                'default' => [
					'unit' => 'px',
					'size' => 2,
				],
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-widget-container:hover' => 'filter: drop-shadow({{shadow_x_hover.SIZE}}{{shadow_x_hover.UNIT}} {{SIZE}}{{UNIT}} {{shadow_blur_hover.SIZE}}{{shadow_blur_hover.UNIT}} {{shadow_color_hover.VALUE}});', 
                ],
                'condition' => [
					'shadow_add_hover' => 'yes', 
				],
			]
        );
		
		$this->add_control(
            'shadow_blur_hover',
            [
				'label' => __( 'Blur', 'asvg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
						'step' => 1,
					],
					'em' => [
						'max' => 10,
						'step' => 0.1,
					],
                ],
                'default' => [
					'unit' => 'px',
					'size' => 2,
				],
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-widget-container:hover' => 'filter: drop-shadow({{shadow_x_hover.SIZE}}{{shadow_x_hover.UNIT}} {{shadow_y_hover.SIZE}}{{shadow_y_hover.UNIT}} {{SIZE}}{{UNIT}} {{shadow_color_hover.VALUE}});', 
                ],
                'condition' => [
					'shadow_add_hover' => 'yes', 
				],
			]
        );
		
		$this->add_control(
 			'shadow_color_hover',
			[
				'label' => __( 'Shadow color', 'asvg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000000A8',
				'selectors' => [
					'{{WRAPPER}} .elementor-widget-container:hover' => 'filter: drop-shadow({{shadow_x_hover.SIZE}}{{shadow_x_hover.UNIT}} {{shadow_y_hover.SIZE}}{{shadow_y_hover.UNIT}} {{shadow_blur_hover.SIZE}}{{shadow_blur_hover.UNIT}} {{VALUE}}); ',
                ],
                'condition' => [
					'shadow_add_hover' => 'yes', 
				],
			]
		);		
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'lottie_border_hover',
				'selector' => '{{WRAPPER}} .asvg-lotties-animation-wrapper:hover',
				'condition' => [
				'add_border_lottie' => 'yes',
				],
			]
		);
		
		$this->add_responsive_control(
			'border_radius_lottie_hover',
					[
				'render_type' => 'ui',
				'type' 			=> Controls_Manager::DIMENSIONS,
				'label' 		=> __( 'Border Radius', 'animatesvg' ),
				'size_units' 	=> [ 'px' ],
				'condition' => [
				'add_border_lottie' => 'yes',
				],
				'selectors' => [
					'{{WRAPPER}} .asvg-lotties-animation-wrapper:hover'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				]
				);

		$this->add_control(
			'hover_animation_lottie',
			[	
				'label' => __( 'Hover animation', 'animatesvg' ),
				'type' => \Elementor\Controls_Manager::HOVER_ANIMATION,
				'prefix_class' => 'elementor-animation-',
			]
		);
		
		
		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->end_controls_section();	
	}


	protected function render() {

		$settings = $this->get_settings_for_display();

				
		$id=uniqid("asvg-lottie");
		
		$start_time=$end_time='';
		if(!empty($settings['custom_time']) && $settings['custom_time']=='yes'){
			$start_time = ($settings['start_time']!='') ? $settings['start_time'] : 1;
			$end_time = ($settings['end_time']!='') ? $settings['end_time'] : 100;
		}
		
		$scrollbased = (!empty($settings['scrollbased'])) ? $settings['scrollbased'] : 'custom';
		$section_duration=500;
		if(!empty($settings['section_duration']['size'])){
			$section_duration = $settings['section_duration']['size'];
		}
		$section_offset=0;
		if(!empty($settings['section_offset']['size'])){
			$section_offset = $settings['section_offset']['size'];
		}
		
		$loop =(!empty($settings['loop']) && $settings['loop']=='true') ? true : false;		
		$max_width =(!empty($settings['max_width']["size"])) ? $settings['max_width']["size"].$settings['max_width']["unit"] : '100%';		
		$minimum_height =(!empty($settings['minimum_height']["size"])) ? $settings['minimum_height']["size"].$settings['minimum_height']["unit"] : '';
		$speed =(!empty($settings['speed']['size'])) ? $settings['speed']['size'] : '1';
		
		
		$action ='';
		if(!empty($settings['action'])){
			$action =$settings['action'];
		}
		if ( $settings["anim_renderer"] ) {
			$anim_renderer = esc_attr($settings["anim_renderer"]);
		}
		
		$content_align=$settings["content_align"];
		$style_atts = $classes = '';
		if ( $content_align ) {
			$classes .= ' align-' . $content_align;
		}
		if ( !empty( $anim_renderer ) ) {
			$classes .= ' renderer-' . $anim_renderer;
		}
		
		if ( !empty( $anim_renderer ) && $anim_renderer == 'html' ) {
			$style_atts .= 'position: relative;';
		}
		if ( !empty( $content_align ) && $content_align == 'right'  ) {
			$style_atts .= 'margin-left: auto;';
		} elseif ( !empty( $content_align ) && $content_align == 'center' ) {
			$style_atts .= 'margin-right: auto;';
			$style_atts .= 'margin-left: auto;';
		}
		
		if ( isset( $settings['column_link'], $settings['column_link']['url'] ) && ! empty( $settings['column_link']['url'] ) ) {
        

        $this->add_render_attribute( '_wrapper', 'class', 'make-column-clickable-elementor' );
        $this->add_render_attribute( '_wrapper', 'style', 'cursor: pointer;' );
        $this->add_render_attribute( '_wrapper', 'data-column-clickable', $settings['column_link']['url'] );
        $this->add_render_attribute( '_wrapper', 'data-column-clickable-blank', $settings['column_link']['is_external'] ? '_blank' : '_self' );
      }
		
		$asvg_opt = '';

		if($settings['customize_url'] == 'yes'){
		if($settings['select_svg_option'] == 'lottie_icons_bas'){
		echo '<div align="center"><span style="font-size: 12px; cursor:pointer"><a href=https://edit.lottiefiles.com/?src=https://assets'.$settings['lottie_icons_bas'].' alt="Open in preview window!" title="Open in preview window!"><b>Click here to customize Lottie.</b></a></span><br><br></div>';
		
				}
				}
		
		if($settings['customize_url'] == 'yes'){
		if($settings['select_svg_option'] == 'lottie_icons_pro'){
		echo '<div align="center"><span style="font-size: 12px; cursor:pointer"><a href=https://edit.lottiefiles.com/?src=https://assets'.$settings['lottie_icons_pro'].' alt="Open in preview window!" title="Open in preview window!"><b>Click here to customize Lottie.</b></a></span><br><br></div>';
		
				}
				}
		
		if ( $settings['json_url']['url'] != '' ) {
			$PATHINFO_EXTENSION = pathinfo($settings['json_url']['url'], PATHINFO_EXTENSION);			
			if($PATHINFO_EXTENSION!='json'){
				echo '<h4>'.esc_html__("Please enter Lottie URL.",'asvg').'</h4>';
				return false;
			}else{				
				$asvg_opt =  'data-id="'.$id.'"';
				$asvg_opt .=  ' data-path="'.$settings['json_url']['url'].'"';		
				$asvg_opt .=  ' data-loop="'.$loop.'"';
				$asvg_opt .=  ' data-width="'.$max_width.'"';
				$asvg_opt .=  ' data-height="'.$minimum_height.'"';
				$asvg_opt .=  ' data-playspeed="'.$speed.'"';
				$asvg_opt .=  ' data-play_action="'.$action.'"';
				$asvg_opt .=  ' data-scrollbased="'.$scrollbased.'"';
				$asvg_opt .=  ' data-section_duration="'.$section_duration.'"';
				$asvg_opt .=  ' data-section_offset="'.$section_offset.'"';
				$asvg_opt .=  ' data-start_time="'.$start_time.'"';
				$asvg_opt .=  ' data-end_time="'.$end_time.'"';
			}
		}
		
		if ( $settings['data_file']!= '' ) {
			
				$asvg_opt =  'data-id="'.$id.'"';
				$asvg_opt .=  ' data-path="'.$settings['data_file']['url'].'"';		
				$asvg_opt .=  ' data-loop="'.$loop.'"';
				$asvg_opt .=  ' data-width="'.$max_width.'"';
				$asvg_opt .=  ' data-height="'.$minimum_height.'"';
				$asvg_opt .=  ' data-playspeed="'.$speed.'"';
				$asvg_opt .=  ' data-play_action="'.$action.'"';
				$asvg_opt .=  ' data-scrollbased="'.$scrollbased.'"';
				$asvg_opt .=  ' data-section_duration="'.$section_duration.'"';
				$asvg_opt .=  ' data-section_offset="'.$section_offset.'"';
				$asvg_opt .=  ' data-start_time="'.$start_time.'"';
				$asvg_opt .=  ' data-end_time="'.$end_time.'"';
		}
		
		if($settings['select_svg_option'] == 'lottie_icons_bas'){
			
				$asvg_opt =  'data-id="'.$id.'"';
				$asvg_opt .= ' data-path="https://assets'.$settings['lottie_icons_bas'].'"';
				$asvg_opt .=  ' data-loop="'.$loop.'"';
				$asvg_opt .=  ' data-width="'.$max_width.'"';
				$asvg_opt .=  ' data-height="'.$minimum_height.'"';
				$asvg_opt .=  ' data-playspeed="'.$speed.'"';
				$asvg_opt .=  ' data-play_action="'.$action.'"';
				$asvg_opt .=  ' data-scrollbased="'.$scrollbased.'"';
				$asvg_opt .=  ' data-section_duration="'.$section_duration.'"';
				$asvg_opt .=  ' data-section_offset="'.$section_offset.'"';
				$asvg_opt .=  ' data-start_time="'.$start_time.'"';
				$asvg_opt .=  ' data-end_time="'.$end_time.'"';
			
			}
		
		if($settings['select_svg_option'] == 'lottie_icons_pro'){
			
				$asvg_opt =  'data-id="'.$id.'"';
				$asvg_opt .= ' data-path="https://assets'.$settings['lottie_icons_pro'].'"';
				$asvg_opt .=  ' data-loop="'.$loop.'"';
				$asvg_opt .=  ' data-width="'.$max_width.'"';
				$asvg_opt .=  ' data-height="'.$minimum_height.'"';
				$asvg_opt .=  ' data-playspeed="'.$speed.'"';
				$asvg_opt .=  ' data-play_action="'.$action.'"';
				$asvg_opt .=  ' data-scrollbased="'.$scrollbased.'"';
				$asvg_opt .=  ' data-section_duration="'.$section_duration.'"';
				$asvg_opt .=  ' data-section_offset="'.$section_offset.'"';
				$asvg_opt .=  ' data-start_time="'.$start_time.'"';
				$asvg_opt .=  ' data-end_time="'.$end_time.'"';
			
			}
		
		$op ='';
			if((!empty($settings['link']) && $settings['link'] == 'yes') && !empty($settings['column_link']['url']) && !empty($settings["link_delay"])){

			$op .='<script>(function($){"use strict";$( document ).ready(function(){$("a.make-column-clickable-elementor").click(function(e){e.preventDefault();var storeurl = this.getAttribute("href");setTimeout(function(){window.location = storeurl;}, '.$settings["link_delay"]["size"].');});});})(jQuery);</script><span style="cursor:pointer">';
			$op .='<a class="make-column-clickable-elementor" href="'.$settings['column_link']['url'].'">';
		}			
		$op .='<div id="'.esc_attr($id).'" class="asvg-lotties-animation-wrapper asvg-'.esc_attr($id).' '.$classes.'"  style="'.$style_atts.'" '.$asvg_opt.'></div>';

		if((!empty($settings['link']) && $settings['link'] == 'yes') && !empty($settings['column_link']['url']) && !empty($settings["link_delay"])){
			$op .='</a></span>';
		}			
		
		echo $op;
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Animated_Svg_Lot() );