<?php

namespace Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Css_Filter;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Multicolor_Svg extends Widget_Base {
		
	public function get_name() {
		return 'multicolor-svg';
	}

    public function get_title() {
        return __('Multi-Color Icons', 'asvg');
    }

    public function get_icon() {
        return 'fa fa-palette asvgnew';
    }

    public function get_categories() {
        return array('animated-svg');
    }

	public function get_script_depends() {
		return ['animated-drwsvg'];
	}
	
	
    protected function _register_controls() {
		
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'asvg' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'select_svg_option',
			[
				'label' => __( 'Select category', 'asvg' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'asvg_basic_icons',
				'label_block' => true,
				'options' => [
					'asvg_basic_icons'  => __( 'Basic icons', 'asvg' ),				
				],
			]
		);
		
		$this->add_control(
			'asvg_basic_icons',
			[
				'label' => __( 'Select SVG icon', 'asvg' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'basic_alarm.txt',
				'label_block' => true,
				'options' => asvg_basic_icons_list_mc(),
				'condition' => [
					'select_svg_option' => 'asvg_basic_icons',					
				],
			]
		);

		$this->add_control(
			'space_pro',
			[
				'label' => __( 'More multi-color icons available in <a href="https://animated-svg.com/" target="_blank"><b>PRO version<b>.', 'asvg' ),
				'type' => Controls_Manager::RAW_HTML,
			
			]
		);		
		
		$this->add_control(
			'svg_type',
			[
				'label' => __( 'Animation type', 'asvg' ),
				'type' => Controls_Manager::SELECT,
				'separator' => 'before',	
				'default' => 'delayed',
				'options' => asvg_svg_type(),
			]
		);
		
		$this->add_control(
            'duration',
            [
                'type' => Controls_Manager::SLIDER,
				'label' => __('Duration (in frames)', 'asvg'),
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 50,
						'max' => 1000,
						'step' => 5,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 90,
				],
            ]
        );		
		
		$this->add_control(
			'on_hover_draw',
			[
				'label' => __( '<alt="Only animates on frontend" title="Only animates on frontend"> Animate on hover? <sup><i class="fa fa-question-circle"></i></sup>', 'asvg' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'asvg' ),
				'label_off' => __( 'No', 'asvg' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'separator' => 'before',	
				
			]
			
          );

      $this->add_control(
			'add_link',
			[
				'label' => __( 'Add link?', 'asvg' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'asvg' ),
				'label_off' => __( 'No', 'asvg' ),
				'return_value' => 'yes',
				'default' => 'no',
				'separator' => 'before',	
			]
			
          );	
		
      $this->add_control(
			'link',
			[
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'asvg' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'add_link' => 'yes',
				],
			]
		);
		
				
		$this->end_controls_section();
		
// Start of style
		
		$this->start_controls_section(
            'section_svg_styling',
            [
                'label' => __('SVG Style', 'asvg'),
                'tab' => Controls_Manager::TAB_STYLE,				
            ]
        );		
		
		$this->add_responsive_control(
            'max_width',
            [
                'type' => Controls_Manager::SLIDER,
				'label' => __('Maximum width of icon (in pixels)', 'asvg'),
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 800,
				],
				'selectors' => [
					'{{WRAPPER}} .pt_plus_animated_svg .svg_inner_block' => 'max-width: {{SIZE}}{{UNIT}};',
				],
            ]

        );

		$this->add_responsive_control(
			'alignment',
			[
				'label' => __( 'Alignment', 'asvg' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'asvg' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'asvg' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'asvg' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .pt_plus_animated_svg-an' => 'text-align: {{VALUE}};',
				],
			]
			);
		
		$this->add_responsive_control(
			'icon_padding',
			[
				'label' => __( 'Padding (in pixels)', 'asvg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px'],
				'selectors' => [
					'{{WRAPPER}} .svg_inner_block' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],			
			]
		);

		
		$this->add_control(
			'space_color',
			[
				'label' => __( '<br><b>Color and stroke width settings</b><br>', 'asvg' ),
				'type' => Controls_Manager::RAW_HTML,
				'separator' => 'before',
			]
		);		
		
		$this->start_controls_tabs( 'tabs_color_style' );
		$this->start_controls_tab(						
			'tab_colors',
			[
				'label' => __( 'Normal', 'asvg' ),
				'condition' => [
				],
			]
		);
		$this->add_control(
			'border_stroke_color',
			[
				'label' => __( 'Color 1', 'asvg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#6942b7',
			]
		);

		$this->add_control(
			'color2',
			[
				'label' => __( 'Color 2 &#40;if available&#41;', 'asvg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#f2295b',
			]
		);
		
		$this->add_control(
            'stroke',
			[
				'label' => esc_html__( 'Stroke width', 'asvg' ),
				'type' => Controls_Manager::NUMBER,
				'label_block' => false,
				'min' => 10,
				'max' => 30,
				'step' => 1,
				'default' => 18,
                'dynamic' => [
                    'active' => false,
                  ],
			]
		);

		$this->add_control(
			'rotate',
			[
				'label' => __( 'Rotate icon', 'asvg' ),
				'type' => Controls_Manager::NUMBER,
				'label_block' => false,
				'min' => -360,
				'max' => 360,
				'step' => 22.5,
				'default' => 0,
                'dynamic' => [
                    'active' => false,
                  ],
			]
		);
		
		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[	
				'name' => 'asvg_css_filters',
				'label' => __( 'CSS filters', 'asvg' ),
				'selector' => '{{WRAPPER}} .svg_inner_block',
				'separator' => 'after',
			]
		);
		
		$this->end_controls_tab();				
		
			
		$this->start_controls_tab(
			'tab_colors_hov',
			[
				'label' => __( 'Hover', 'asvg' ),
				'condition' => [
				],
			]
		);		

		$this->add_control(
			'border_stroke_color_hov',
			[
				'label' => __( 'Color 1', 'asvg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#f2295b',
			]
		);
	
		$this->add_control(
			'color2_hov',
			[
				'label' => __( 'Color 2 &#40;if available&#41;', 'asvg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#6942b7',
			]
		);
				
		
		$this->add_control(
            'stroke_hov',
			[
				'label' => esc_html__( 'Stroke width', 'asvg' ),
				'type' => Controls_Manager::NUMBER,
				'label_block' => false,
				'min' => 10,
				'max' => 30,
				'step' => 1,
				'default' => 24,
                'dynamic' => [
                    'active' => false,
                  ],
			]
		);
		
		$this->add_control(
            'transition_hov',
			[
				'label' => esc_html__( 'Transition duration', 'asvg' ),
				'type' => Controls_Manager::NUMBER,
				'label_block' => false,
				'min' => 0.1,
				'max' => 5,
				'step' => 0.5,
				'default' => 0.5,
                'dynamic' => [
                    'active' => false,
                  ],
			]
		);

		$this->add_control(
			'rotate_hov',
			[
				'label' => __( 'Rotate icon', 'asvg' ),
				'type' => Controls_Manager::NUMBER,
				'label_block' => false,
				'min' => -360,
				'max' => 360,
				'step' => 22.5,
				'default' => 0,
                'dynamic' => [
                    'active' => false,
                  ],
			]
		);
				
		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[	
				'name' => 'asvg_css_filters_hov',
				'label' => __( 'CSS filters', 'asvg' ),
				'selector' => '{{WRAPPER}} .svg_inner_block:hover',
				'separator' => 'after',
			]
		);
			
		$this->add_control(
			'hover_animation',
			[	
				'label' => __( 'Hover animation', 'asvg' ),
				'type' => \Elementor\Controls_Manager::HOVER_ANIMATION,
				'prefix_class' => 'elementor-animation-',
			]
		);	
	

		$this->end_controls_tab();
		$this->end_controls_tabs();
		
				   
		$this->add_control(
			'entrance_animation',
			[
				'label' => __( '<b>Entrance animation</b>', 'asvg' ),
				'type' => \Elementor\Controls_Manager::ANIMATION,
				'prefix_class' => 'animated ',
			]
		
				);
				
		$this->end_controls_section();	
	}
	
	 protected function render() {
        $settings = $this->get_settings_for_display();
		$alignment=$settings["alignment"];
		$uid=uniqid('svg');
		$hover_draw='';
		$color2 = $settings['color2'];
		$border_stroke_color_hov = $settings['border_stroke_color_hov'];
		$color2_hov = $settings['color2_hov'];
		$stroke = $settings['stroke'];
		$stroke_hov = $settings['stroke_hov'];
		$transition_hov = $settings['transition_hov'];
		$rotate= $settings['rotate'];
		$rotate_hov = $settings['rotate_hov'];
		

			if($settings['select_svg_option'] == 'asvg_basic_icons'){
				$svg_url = ASVG_IMGS.'/svg/'.esc_attr($settings["asvg_basic_icons"]);		
			}
				
			if($settings['border_stroke_color'] !=''){
				$border_stroke_color=$settings['border_stroke_color'];
			}else{
				$border_stroke_color='none';
			}
		 
			if(!empty($settings['on_hover_draw']) && $settings['on_hover_draw']=='yes'){
				$hover_draw='plus-hover-draw-svg';
			}
			
			if($settings['add_link'] == 'yes'){	
			echo '<a href="'. $settings['link']['url'] . '"' . $target . $nofollow . '>';}
			
			echo '<div class="pt_plus_animated_svg-an">';
			echo '<div class="pt_plus_animated_svg '.esc_attr($hover_draw).' '.esc_attr($alignment).' '.esc_attr($uid).' '.esc_attr($animated_class).'" '.$animation_attr.'
			data-id="'.esc_attr($uid).'" data-type="'.esc_attr($settings["svg_type"]).'" data-duration="'.esc_attr($settings['duration']['size']).'">';
			echo '<div class="svg_inner_block">';?>
 
			<svg version="1.1" stroke="#ffffff00" id="<?php echo $uid ?>" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
			 width="100%"  heigth="100%" viewBox="0 0 800 800" style="enable-background:new 0 0 800 800" xml:space="preserve">
			<style type="text/css">
			.st0{fill:#ffffff00;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;}
			g#<?php echo $uid ?>{fill:#ffffff00;stroke:<?php echo $border_stroke_color ?>;stroke-width:<?php echo $stroke ?>;transition:<?php echo $transition_hov ?>s;}
			g#<?php echo $uid ?>:hover{fill:#ffffff00;stroke:<?php echo $border_stroke_color_hov ?>;stroke-width:<?php echo $stroke_hov ?>;transition:<?php echo $transition_hov ?>s;}</style>
			<g id="<?php echo $uid ?>">
			<?php echo file_get_contents("$svg_url");?><?php echo '</g></svg>';?>
			<?php echo'</div></div></div>'; if($settings['add_link'] == 'yes'){	 echo '</a>';} ?>
				<style>#<?php echo $uid; ?> .accent {fill:#ffffff00;stroke:<?php echo $color2 ?>;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;}
				g#<?php echo $uid; ?>:hover .accent {fill:#ffffff00;stroke:<?php echo $color2_hov?>;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;}
				svg#<?php echo $uid ?> {-webkit-transition: -webkit-transform <?php echo $transition_hov ?>s ease-in-out;-moz-transition: -moz-transform <?php echo $transition_hov ?>s ease-in-out;transition: transform <?php echo $transition_hov ?>s ease-in-out;
				transform:rotate(<?php echo $rotate; ?>deg);-moz-transform:rotate(<?php echo $rotate; ?>deg);-webkit-transform:rotate(<?php echo $rotate; ?>deg);}
				svg#<?php echo $uid ?>:hover {transform:rotate(<?php echo $rotate_hov; ?>deg);-moz-transform:rotate(<?php echo $rotate_hov; ?>deg);-webkit-transform:rotate(<?php echo $rotate_hov; ?>deg);}
					</style>
			<?php


	}


}
Plugin::instance()->widgets_manager->register_widget_type( new Multicolor_Svg() );